//This file is part of FiveIMSNickCollinsPhD. Copyright (C) 2006  Nicholas M.Collins distributed under the terms of the GNU General Public License full notice in file FiveIMSNickCollinsPhD.help


//diagnostic short lived Synth? obtains soundtrack params etc

//spawn OSCresponderNodes as desired as long as you remove them again! 

//idea- have various global fx, ie tank reverb, switch send strength by snare hits

DrumTrackSystem {
	var <s, <c; //c is master clock for cutters
	var node1,<trackgroup, <synthgroup, <fxgroup;
	var <trackbus, sourcesynth, tracksynth, trackindex;
	//var sourcebuf;
	var <kickonsets, <snareonsets, <kitenergy;
	var <beatbus;
	
	var kicktrack, snaretrack, amptrack;
	var <kickID, <snareID, <beatID; //for onset triggers
	var debug, drumbus, debugmixsynth;
	var <breaks, <kicks, <snares, <hats;
	var numcapbufs,capbufs, capbufsavailable, breakcorebuf;
	var mixsynth;
	
	var length, synthdata, synthprob;	
	var l, task;//<running;
	
	//plan for parameter variation over time, show on a GUI to the performer? 
	var length, cooperationenv, violenceenv;
	var synthdensity, beatdensity, cutdensity; 
	//var specialevent, specialeventtime, nextspecialevent;
	var events, nextevent;
	var cutoptions, fxoptions;

	//current values, used by spawned cutters etc
	var cooperation, violence, density; 	
	
	//debug control of spawned elements
	var <>numsynths,<>numcuts,<>numbeats;
	
	//capture events from diskin
	var ce, diskinbus, diskinbuf, diskinfiles, whichdiskin;
	
	//stats- kicks per sec etc, Amplitude? 
	var rmsbus,rms,kickpersec, snarepersec, activity; 
	var kicktimes, snaretimes;
		
	//play state
	var nextnum, runningcutters, runningbeats, runningsynths;
		
	//external clock
	var inductprop, externalbus, externalprop;
	
	*new{arg l, debug=false;
		^super.new.initHackerDrummerTracker(l, debug);
	}
	
	initHackerDrummerTracker {arg livecode,dbg=false;
		var b, readytask, condition;
		
		l=livecode;
		
		debug=dbg;
	
		//initialise, remove all existing OSCresponderNodes
		OSCresponder.all.do({arg val; if(val.cmdName=='/tr',{OSCresponder.remove(val)}); });
	
		s=Server.default;
		s.latency=0.04;
		
		node1= Node.basicNew(s,1);
		
		trackgroup= Group.head(node1);
		synthgroup= Group.after(trackgroup);
		fxgroup= Group.after(synthgroup);
		
		kickID=70;
		snareID=71;
		beatID=100;
		
		kickonsets=Bus.control(s,1); //Bus.audio(s,1);
		snareonsets=Bus.control(s,1); //Bus.audio(s,1);
		kitenergy=Bus.control(s,1);
		
		//track beat, halfbeat, quarterbeat, tempo
		beatbus=Bus.control(s,4);
				
		//will need two of these for stereo in, kick and snare  
		trackbus= Bus.audio(s,2);
		
		//activity tracking
		activity=0;
		rmsbus=Bus.control(s,1);
		
		//external clock bus
		externalbus=Bus.control(s,1);
		
		if(debug,{
		
			b= ["sounds/SCsamp/percussion/BD3.wav","sounds/SCsamp/percussion/SD3.wav","sounds/SCsamp/percussion/HH3.wav"];
	
			b= Array.fill(b.size,{arg i; 
			
			//BBCutBuffer.read(s,b[i],action:{arg buf; buf.beats_(2);})
			
			BBCutBuffer(b[i],2,nil)
			
			});
	
			MIDIClient.init;
			MIDIIn.connect;
			
			drumbus= Bus.audio(s,2);
				
	//	Out.ar(0,source);
	
	SynthDef(\hdtbeatboxdebug,{var source; source=AudioIn.ar(1).dup; Out.ar(drumbus.index,source);

	}).play(RootNode.new,addAction:\addToHead);	
			"debug here".postln;	
			//	
//					
//			MIDIIn.noteOn = { |port, chan, note, vel| 
//			//[port, chan, note, vel].postln ;
//			
//			if(note==60, {
//			Synth.head(trackgroup,\hdtplaydrum, [\outbus, drumbus.index,\bufnum, b[0].bufnum, \amp, 1.0, \dur, b[0].length]);
//			});
//			
//			if(note==62, {
//			Synth.head(trackgroup,\hdtplaydrum, [\outbus, drumbus.index+1,\bufnum, b[1].bufnum, \amp, 1.0,  \dur, b[1].length]);
//			});
//			
//			if(note==66, {
//			Synth.head(trackgroup,\hdtplaydrum, [\outbus, drumbus.index+1,\bufnum, b[2].bufnum, \amp, 1.0,  \dur, b[2].length]);
//			});
//		};
//			
		
		});
		
		//trigger ID defaults to 50
		ce= CaptureEventsManager(oscout:(LCTempoControl.oscout));
		diskinbus= Bus.audio(s,1); //mono streams only
			
		
		condition= Condition.new;
		
		Routine.run({
		
		s.sync(condition);	
		this.initBuffers;
		s.sync(condition);		
		//this.initGUI;
		this.initTracking;
		s.sync(condition);
		this.initComposition;
		s.sync(condition);
		});
		
		
		//
//		readytask= Task({
//
//		0.5.wait;
//		this.initBuffers;
//		0.5.wait;
//		//this.initGUI;
//		this.initTracking;
//		0.5.wait;
//		this.initComposition;
//		
//		"initialised HackerDrummerTracker".postln;
//		}, AppClock);
//		
//		readytask.start;

			//for debug
			numsynths=4;
			numbeats=4;
	
	}
	
	//will load percussion kits automatically
	initBuffers {				//arg source, breakarray, samparray;
		var breakfilenames, breaklengths; 
		var list;

		//sourcebuf=Buffer.read(s, source);

		breakfilenames= Array.fill(9,{arg i; var str;
			str=("sounds/SCsamp/breaks/hiphop/hop"++(i+1).asString);
			
			if((i==3) || (i==5),{str=str++".aif"});
			str
		});

		breaklengths= [4,4,8,4,8,4,4,8,8];
		
		//action:{arg buf; buf.beats_(breaklengths[i]);}
		breaks= Array.fill(breaklengths.size,{arg i; BBCutBuffer(breakfilenames[i],breaklengths[i],nil)});

		list=List.new;

		10.do({arg i; 	
			list.add("sounds/SCsamp/percussion/BD"++((i+1).asString)++(".wav")); 
			list.add("sounds/SCsamp/percussion/SD"++((i+1).asString)++(".wav")); 
			list.add("sounds/SCsamp/percussion/HH"++((i+1).asString)++(".wav")); 
		});

		
		kicks= Array.fill(10,{arg i; 
		
		//BBCutBuffer.read(s,list[3*i],action:{arg buf; buf.beats_(2);})
		
		BBCutBuffer(list[3*i],2,nil)
		});
		snares= Array.fill(10,{arg i; 
		
		//BBCutBuffer.read(s,list[3*i+1],action:{arg buf; buf.beats_(2);})
		BBCutBuffer(list[3*i+1],2,nil)
		
		});
		hats= Array.fill(10,{arg i; 
		//BBCutBuffer.read(s,list[3*i+2],action:{arg buf; buf.beats_(2);})
		
		BBCutBuffer(list[3*i+2],2,nil)
		});
		
		//make five different ones?
		numcapbufs=4;
		numcuts=numcapbufs;
		
		capbufs=Array.fill(numcapbufs,{BBCutBuffer.alloc(s,44100 * 1.0,1)}); //capture buffer
		capbufsavailable= List.fill(numcapbufs,{arg i; i});
		
		breakcorebuf= Buffer.alloc(s,44100);
		
		//disk in for pieces to be controlled- New Order etc 
		//check these- first four good
		diskinfiles= [
		"/Volumes/data/stevebeattrack/samples/051.wav",
		"/Volumes/data/stevebeattrack/samples/052.wav",
		"/Volumes/data/stevebeattrack/samples/053.wav",
		"/Volumes/data/stevebeattrack/samples/054.wav",
		
		"/Volumes/data/stevebeattrack/samples/055.wav",
		"/Volumes/data/stevebeattrack/samples/056.wav",
		"/Volumes/data/stevebeattrack/samples/057.wav",
		"/Volumes/data/stevebeattrack/samples/058.wav",
		].scramble;
		whichdiskin=0;
		
		diskinbuf=Array.fill(diskinfiles.size, {arg i; Buffer.cueSoundFile(s,diskinfiles[i],0,1)});
		
	}
	
	initTracking {
	
		trackindex=8; //default to audio ins 1 and 2 unless debugging
		
		c=ServerClock.new; //BBInduct.new;

		c.play(beatID); //trigID 100
		
		//sourcesynth=Synth.tail(trackgroup, \hdtsource, [\bufnum, sourcebuf.bufnum, \outbus,trackbus.index]);
		
		if(debug,{
		
		trackindex=trackbus.index;
		sourcesynth=Synth.head(trackgroup,\hdtdebug, [\outbus, trackindex,\inbus,drumbus.index, \crosstalk, 0.1]); //0.25 higher value unrealistic
		
		debugmixsynth=Synth.tail(trackgroup,\hdtdebugmix,[\outbus, 0,\inbus,trackindex]);
		
		});
		
		//tracksynth= Synth.tail(trackgroup,\hdtdrumtrack,[\inbus,trackindex, \beatbus, beatbus.index, \inductprop,1.0, \externalbus,externalbus.index,\externalprop,0.0]);
		
		tracksynth= Synth.tail(trackgroup,\hdtautotrack,[\inbus,trackindex, \beatbus, beatbus.index, \inductprop,1.0, \externalbus,externalbus.index,\externalprop,0.0]);
		
		
		//kick is L channel
		kicktrack=Synth.tail(trackgroup, \hdtonset, [\inbus, trackindex, \outbus,kickonsets.index, \threshold, 0.9, \trigID, kickID]);
		
		//snare is R channel
		snaretrack=Synth.tail(trackgroup, \hdtonset, [\inbus, trackindex+1, \outbus,snareonsets.index, \threshold, 0.9, \trigID, snareID]);
		
		amptrack= Synth.tail(trackgroup, \hdtenergy, [\inbus, trackindex, \outbus,kitenergy.index, \rmsbus, rmsbus.index]);
		
		amptrack.nodeID.postln;
		
		//LiveCoding1 will deal with this
		//mixsynth= Synth.tail(fxgroup, \hdtmainmix, [\inbus, 0, \outbus,0]);
	
		ce.capturebus.set(diskinbus.index);
		ce.play2(trackgroup); //CaptureEvents2 UGen
		ce.run(true); //always on
		
		kicktimes= List.new;
		snaretimes= List.new;
		
		//OSCresponders for kick and snare activity, rms polling
		OSCresponderNode(s.addr, '/tr', { arg time, responder, msg;
			
			if(msg[2]==kickID,{
			
			//["kick!", msg[2], msg,time].postln;
			
			kicktimes.add(time);
			
			});
			
		}).add;
		
				
		//OSCresponders for kick and snare activity, rms polling
		OSCresponderNode(s.addr, '/tr', { arg time, responder, msg;
			
			if(msg[2]==snareID,{
		
			snaretimes.add(time);
		
			});
			
		}).add;
		
		
		//5 times per second
		SystemClock.sched(0.0,{
		var near;
		
		near= Main.elapsedTime-3.0;
		
		//clear any old times
		
		kicktimes= kicktimes.select({arg val, i; if(val>near,true,false)}).asList;
		
		snaretimes= snaretimes.select({arg val, i; if(val>near,true,false)}).asList;
		
		rmsbus.get({arg val;

		rms=val;  
		
		//could involve violenceenv too
		activity= (0.5*(5*rms)+(0.25*(kicktimes.size/15))+(0.25*(snaretimes.size/15))).clip2(1.0);
		
		//[activity, activity.coin].postln;
		//Post << ["activity", rms,activity,kicktimes.size,snaretimes.size]<<nl;
		});
		
		0.2;
		});
		
		
	}
	
	setThresholds {arg kickthresh=0.8,snarethresh=0.8;
		
		kicktrack.set(\threshold,kickthresh);
		snaretrack.set(\threshold,snarethresh);
	
	}
	
	
	
	initComposition {
		var temp, temp2, opening, ending, middle;
		
		//just one element as a test
		//Dictionary? 
		//running=List.new;
		
		
		length= rrand(9.0,12.0)*60.0; //some arbitrary length
		
		opening=60.0;
		ending=60;
		middle=length-opening-ending;
		
		//make nice shapes, can add extra segments if not varied enough, probably want to plot them to show drummer position
		
cooperationenv=Env([1,1,0,1,1,0,0,1,1,0,1,1],([0.1,0.2,0.5,0.5,1.0,1.0,rrand(0.01,0.1),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0)].scramble.normalizeSum)*length,'sine'); 
		
		violenceenv=Env([0,1]++(Array.fill(7,{rrand(0.0,1.0)}))++[0,1,1],([0.1,0.2,0.5,0.5,1.0,1.0,rrand(0.01,0.1),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0)].scramble.normalizeSum)*length,'sine'); 
		

//controlling spread of various factors, may need revision 

	
//no beats until at least 130 seconds in, no spawns in final region 
		//synthdensity=Env([0]++((Array.fill(7,{rrand(0.0,1.0)})++[1,1,1]).scramble)++[1],([0.1,0.2,0.5,0.5,1.0,1.0,rrand(0.01,0.1),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0)].scramble.normalizeSum)*length,'sine'); 
	
synthdensity=Env([0,0]++((Array.fill(7,{rrand(0.0,1.0)})++[1,1,1]).scramble)++[1,0],[30]++(([0.1,0.2,0.5,0.5,1.0,1.0,rrand(0.01,0.1),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0)].scramble.normalizeSum)*middle)++[ending+30],'sine'); 
			beatdensity=Env([0,0]++((Array.fill(7,{rrand(0.0,1.0)})++[1,1,1]).scramble)++[1,0],[opening]++(([0.1,0.2,0.5,0.5,1.0,1.0,rrand(0.01,0.1),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0)].scramble.normalizeSum)*middle)++[ending],'sine'); 
		
	//[0]++((Array.fill(7,{rrand(0.0,1.0)})++[1,1,1]).scramble)++[1],([0.1,0.2,0.5,0.5,1.0,1.0,rrand(0.01,0.1),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0)].scramble.normalizeSum)*length,'sine'
	cutdensity=Env([0,0]++((Array.fill(7,{rrand(0.0,1.0)})++[1,1,1]).scramble)++[1,0],[opening]++(([0.1,0.2,0.5,0.5,1.0,1.0,rrand(0.01,0.1),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0),exprand(0.01,1.0)].scramble.normalizeSum)*middle)++[ending],'sine'); 
	 
		
		//possible synths, chance of each, constructor functions. CPU cost taken as related to rarity
		//chances relate to violence env, blend two prob arrays
		//argument for violence factor?
		
		//[\hdtonsetbass1, \hdtonsetbass2, \hdtonsetbass3, \hdtgendy1].choose;
		synthdata= [
		{[\hdtonsetbass1, [\onsetbus,[snareonsets.index, kickonsets.index, (beatbus.index+(3.rand))].choose, \pan, 0.8.rand2,
		\centrefreq, exprand(200,2000), \rq, exprand(0.1,0.3), \basefreq, exprand(20,80), \lfospeed,exprand(0.1,1.0)]]},
		{[\hdtonsetbass2, [\onsetbus,[snareonsets.index, kickonsets.index,(beatbus.index+(3.rand))].choose, \bufnum, [{breaks[9.rand].bufnum},{ce.eventbuf.bufnum}].choose.value,\basefreq, exprand(30,90), \lfospeed,exprand(0.1,5.0), \prop, exprand(0.01,0.5),\startPos, rrand(0,44100)]]},
		{[\hdtonsetbass3, [\onsetbus,[snareonsets.index, kickonsets.index, (beatbus.index+(3.rand))].choose, \bufnum, [{breaks[9.rand].bufnum},{ce.eventbuf.bufnum}].choose.value,\basefreq, exprand(20,50), \lfospeed,exprand(0.1,5.0), \drive, exprand(1,30), \prop, exprand(0.01,0.5),\startPos, rrand(0,44100)]]},
		{[\hdtgendy1, [\inbus,kitenergy.index, \tempo, (beatbus.index)+3, \minfreq, exprand(20,50),\centrefreq, exprand(200,5000), \rq, exprand(0.1,0.5), \panspeed,exprand(0.01,0.3),\panspread,rrand(0.1,0.8), \ampscale,[0.5,rrand(0.1,1.0),exprand(0.1,1.0)].choose, \durscale,[0.005,rrand(0.001,0.01),exprand(0.001,0.1),rrand(0.01,0.5)].wchoose([0.4,0.3,0.2,0.1]), \initCPS, rrand(2,15)]]},
		
		//more! 
		
		
		];
		
		//\outbus,index,\inbus,kitenergy.index,\onsetbus,[snareonsets.index, kickonsets.index].choose, \pan, 0.8.rand2, \tempo, c.tempoclock.tempo, \bufnum, breaks[9.rand].bufnum
		
		//probs can vary over course of composition, this is algorithmically generated from a basic CPU cost profile 
		synthprob=[0.4,0.3,0.2,0.1];
		
		//each will have its own method in this class to make it, and can occur only once
		//specialevent= [\breakcore, \gravitygrid, \popsteal].scramble;
//			
//		specialevent= [\start]++specialevent++[\end]; //the end function is always called 	
//		specialeventtime= [0]++([rrand(180,240), rrand(350,450),rrand(550,650)])++ [length-30];
//		
		
		
		events= List.new; 
		events.add([0.0,\start]);
		
		events.add([30, \firstcut]);
		
		events.add([40, \gendy1]);
		
		events.add([50, \nasty4]);
		
		temp= [\breakcore, \gravitygrid, \popsteal].dup.flatten.scramble;
		
		//at least a minute gap between them
		temp2=  Array.fill(6, {arg i; (length/7)*(i+1)+(10.rand2)}); 
		
		temp2.postln;
		
		6.do({arg i; events.add([temp2[i],temp[i]])});
		
		temp= (length/4)*[1,2,3]; //[1,2,3] //+(50.rand2)
		
		3.do({arg i; events.add([temp[i]+(50.rand2),\otherclock])});
		
		events.add([length-30, \end]);
		events.add([length-60, \startend]);
		
		events.add([length-90, \nasty4]);
		
		events.add([length*0.76, \suppression]);
		
		events.add([length*0.26, \support]);
		
		events.add([length*0.3, \suppression]);
		
		events.add([length*0.9, \support]);
		
		events.add([length*0.86, \nasty2]);
		
		
		
		events=events.sort({arg a,b; a[0]<=b[0]}); 
		
		//make iois for SystemClock use?
		
		Post << events << nl; 
		
		events.do({arg ev, i;  if(i<(events.size-1),{ev[0]= (events[i+1][0])- (events[i][0]);},{ev[0]=nil;})  });
		
		Post << events << nl; 
		
		nextevent=0;
		
		cutoptions= [	
			{BBCutProc11([8,12,16].wchoose([0.8,0.1,0.1]),4.0,rrand(1,4), nil, rrand(0.05,0.5),[2,3,4].wchoose([0.7,0.1,0.2]),[0.25,0.5,1.0].choose)},
			{ChooseCutProc({[0.5,1.0].choose},{[1,2,4].choose},rollchance:0.0)},
			{ChooseCutProc({0.25},{[2,4].choose},rollchance:0.25)},
			{ChooseCutProc({0.125},{[4,8].choose},rollchance:0.25)},
			{ChooseCutProc({[1.5,1.0,0.5].choose},{[1,2,4].choose},rollchance:0.5)},
			{WarpCutProc1({[1.0,0.5].choose},{[1,2,4,8].choose},[rrand(0.0,1.0),rrand(0.0,1.0),rrand(0.0,1.0)],rrand(0.75,0.99))},
			{SQPusher1(rrand(0.0,1.0),rrand(1,7),rrand(0.0,1.0), Array.fill(8,{arg i; if(i.even,{rrand(0.0,0.6)}, {rrand(0.2,1.0)})}), 0.5)},
			{
			var fillchance;
			
			fillchance= rrand(0.0,1.0).squared;
			
			ThrashCutProc1(rrand(0,3)/4,rrand(0,3)/4+0.125,4.0,[[0.25,0.25,0.125,0.125,0.25],[0.375,0.375,0.25],[0.125,0.125,0.75]].choose,nil, rrand(2,5), {fillchance.coin}, rrand(0.0,0.5))},
			{RecursiveCutProc1.new({[4.0,2.5,1.5].choose},{rrand(1,3)},nil,rrand(2,5))},
			{
			var permutefunc, stutterfunc, randnum1, randnum2;
			
			randnum1= rrand(1.3,4.1);
			randnum2= rrand(7,14.7);
			
			permutefunc= [
			{arg index, n;  if(index%2==0,{index+1},{index-1})},
			{arg index, n;  n-index-1},
			{arg index, n;  (randnum1*n*n*index)+(randnum2.rand2)},
			{arg i,n; (((i+randnum1).rand)**(i.min(randnum2)))%n},
			{arg i,n; ((i+(i.rand))*(rrand(2,i)))%n}
			].choose; 
			
			stutterfunc= [
			{arg index; if((index==4) || (index==7), 3, 1)},
			2,
			4,
			{arg index; if(index.even, 2, 1)},
			{arg index; if(index.odd, 4, 1)}
			].choose; 
			
			BBCPPermute.new(8.0,16,permutefunc,stutterfunc) 
			}
			
			
		];
	
				
		fxoptions = [{
			var cfreq, rq,drq;
			
			cfreq= [exprand(500,7500),{arg block; (block.phraseprop)*1000+5000}, {exprand(500,7500)}].choose;
			rq= [0.1,exprand(0.05,0.5),{exprand(0.05,0.5)}].choose;
			drq= [rrand(1.01,1.1),{rrand(1.01,1.05)},{rrand(1.01,1.1)}].choose;
			
			CutBRF1(cfreq,rq,drq)
			},{
			var cfreq, rq,drq;
			
			cfreq= [exprand(500,7500),{arg block; (block.phraseprop)*1000+5000}, {exprand(500,7500)}].choose;
			rq= [1,exprand(0.5,2),{exprand(0.5,2)}].choose;
			drq= [rrand(0.9,0.99),{rrand(0.9,0.99)},{rrand(0.8,0.9)}].choose;
			
			CutBPF1(cfreq,rq,drq)
			},{
			var modfreq,mfmult,modamount,mamult;
			
			modfreq=[exprand(100,1000),{exprand(100,1000)},{exprand(500,5000)}].choose;
			mfmult=[rrand(0.8,1.2),{rrand(0.9,1.1)},{rrand(0.8,1.2)}].choose;
			modamount=[1.0,rrand(0.5,1.0),{rrand(0.0,1.0)}].choose;
			mamult=[1,{rrand(0.9,0.99)},{rrand(0.8,0.95)}].choose;
			
			CutMod1(modamount,modfreq,mamult,mfmult)
			},{
			var bits,bitadd,sr,srmult;
			
			bits=[16,rrand(3,16),{rrand(2,16)},{rrand(3,10)},{rrand(3,6)}].choose;
			bitadd=[-0.5,-1,rrand(-4,-1),{rrand(-0.5,-0.1)},{rrand(-2,-0.1)},{rrand(-4,-1)}].choose;
			sr=[22050,exprand(10000,20000),{exprand(5000,22050)},{rrand(1000,5000)}].choose;
			srmult=[rrand(0.5,0.9),rrand(0.8,0.99),{rrand(0.8,0.99)},{rrand(0.5,0.99)}].choose;
			
			CutBit1(bits,sr,bitadd,srmult);
			},
			{var tune, deltime, dectime;
			
			tune=[#[36,50,64,65,67,69,70,72,74,73,72,70,69,70,69,67,67,60,60],
			#[36,48,48.3,47.7,47.1,36,36.5,35.5,36]
			].choose.midicps.reciprocal; 
			
			deltime= [{arg i; tune.wrapAt(i)},{arg i,block; (i.clip2(10)*0.01)+0.01}].choose;
			dectime= [0.2, {arg i; (i.clip2(10)*0.2)+0.1}].choose;
			
			CutComb1(deltime,dectime);
			},
			{var amount,send;
			
			amount=[0.1,0.3,exprand(0.01,0.3)].choose;
			send= [1,{arg i,block; if(i==0,1,0)}, {arg i,block; (i.clip2(10))*0.1}, {arg i,block; if(i.even,1,0)}].choose;
			
			CutRev1(amount,send);
			}
			];			
	
				
		
	}
	
	run {
		var clock; 
		
		runningsynths=0;
		runningcutters=0;
		runningbeats=0;
		
		"running!".postln;
		
		clock=TempoClock(1); 
	
		nextnum=0;
	
		task=Task({
			var done, dur, timespan;
			var active, name,numspawn,shouldsynth,shouldcut,shouldbeat, killchance;
			
			done=0.0;
			
			while({done<length}, {
			
			//to spawn or kill...spawn chance, kill chance envelopes separate? 
			//may be different start/stop tactics 
			
			//shouldsynth= numsynths; //((synthdensity.at(done))*5).round;
			//shouldcut= numcuts;//((cutdensity.at(done))*(numcapbufs)).round; //can be zero!
			//shouldbeat= numbeats;//((beatdensity.at(done))*5).round;
			
			shouldsynth= ((synthdensity.at(done))*numsynths).round;
			shouldcut= ((cutdensity.at(done))*(numcapbufs)).round; //can be zero!
			shouldbeat= ((beatdensity.at(done))*numbeats).round;
			
			
			//tells you number that should be playing- 16*density
		
			//have to be careful about spawning too much
			
			if(runningsynths<shouldsynth, {
				this.makesynth; 			
			});
			
			
			//add bbcut2 instance with kill function to stop itself, reccutbufs to start with
			//more abrupt envelopes for cutters? 
			//numcapbufs, 1 for testing for now
			
			//CHECK IT! May be unsafe for multiple cutters, what is going on...
			if(runningcutters<shouldcut,{
				this.makecutter; 
			});
			
			
			//beats can be CutKick1 or CutBuf1 or CutBuf2
			
			if(runningbeats<shouldbeat,{
				this.makebeat;
			});
			
			//Post << [nextspecialevent,specialevent,specialevent.size,done,specialeventtime] << nl;
					
			dur=1.0;
			done=done+dur;
			
			dur.wait;
			});
			
		}, clock);
		
		task.start;
		
		//	
//			if(nextspecialevent<(specialevent.size),{
//				
//				if(done>=specialeventtime[nextspecialevent],{
//				
//					this.perform(specialevent[nextspecialevent]);
//	
//					nextspecialevent=nextspecialevent+1;
//				
//				});
//				
//			});

		
		//first is at 0.0 
		SystemClock.sched(0.0,{
		var event;
		
		event= events[nextevent];
		
		this.perform(event[1]);
		
		nextevent=nextevent+1;			
		
		event[0]
		}); 
		
			
		}
	
	
		
	
	stop {
		task.stop;
		l.stop;
		//w.close;
		s.freeAll;
		SystemClock.clear;
		AppClock.clear;
	}
	
	
	
	//SynthDefs for tracking and setup
	*initClass {
	
		StartUp.add({
	
		SynthDef.writeOnce(\hdtdrumtrack,{arg inbus, dynleak=0.8, alpha=1,beta=2, bassevidence=1.0, patternevidence=1.0, beatbus, inductprop=1.0, externalbus, externalprop=0.0;
		var trackb,trackh,trackq,tempo, beep1,beep2,beep3;
		var clock;
			#trackb,trackh,trackq,tempo=DrumTrack.kr(Mix(In.ar(inbus,2)),dynleak,alpha,beta,bassevidence,patternevidence);
		
		//beep1=SinOsc.ar(1000,0.0,Decay.kr(trackb,0.1));
		//
		//beep2=SinOsc.ar(2000,0.0,Decay.kr(trackh,0.1));
		//
		//beep3=SinOsc.ar(4000,0.0,Decay.kr(trackq,0.1));
		
		//Out.ar(1,beep1); //(+beep2+beep3)
		
		//can potentially disrupt this with an ona*trackb+onb*Impulse.kr(externaltempo); 
		
		clock= (inductprop*trackb) + (externalprop*(In.kr(externalbus,1))); 
		
		//PrintVal.kr(inductprop,200,1);
//		PrintVal.kr(externalprop,200,2);
//		
//		PrintVal.kr(clock,1,3);
		
		SendTrig.kr(clock,100,tempo); //to control bbcut
		
		Out.kr(beatbus,[trackb,trackh,trackq,tempo]);
		
		});
		
		
		
		SynthDef.writeOnce(\hdtautotrack,{arg inbus, beatbus, inductprop=1.0, externalbus, externalprop=0.0;
		var trackb,trackh,trackq,tempo, beep1,beep2,beep3;
		var clock;
			#trackb,trackh,trackq,tempo=AutoTrack.kr(Mix(In.ar(inbus,2)));
		
		//beep1=SinOsc.ar(1000,0.0,Decay.kr(trackb,0.1));
		//
		//beep2=SinOsc.ar(2000,0.0,Decay.kr(trackh,0.1));
		//
		//beep3=SinOsc.ar(4000,0.0,Decay.kr(trackq,0.1));
		
		//Out.ar(1,beep1); //(+beep2+beep3)
		
		//can potentially disrupt this with an ona*trackb+onb*Impulse.kr(externaltempo); 
		
		clock= (inductprop*trackb) + (externalprop*(In.kr(externalbus,1))); 
		
		//PrintVal.kr(inductprop,200,1);
//		PrintVal.kr(externalprop,200,2);
//		
//		PrintVal.kr(clock,1,3);
		
		SendTrig.kr(clock,100,tempo); //to control bbcut
		
		Out.kr(beatbus,[trackb,trackh,trackq,tempo]);
		
		});

		
		
			
		///for debug mode, MIDI triggered kit		
		SynthDef.writeOnce(\hdtplaydrum,{arg bufnum,outbus,amp, dur;
		var pb;
		
		pb= EnvGen.ar(Env([1,1],[dur]),doneAction:2)*PlayBuf.ar(1,bufnum, loop:1);
				
		Out.ar(outbus,pb*amp);
		});

		SynthDef.writeOnce(\hdtdebug,{arg outbus, inbus, crosstalk;
		var sig,in, left, right;
			
			in= In.ar(inbus,2);
			left= in[0]+ (crosstalk*in[1]);
			right= in[1]+ (crosstalk*in[0]);
			
			sig= [left,right];
			
			//add reverberation?
			
			Out.ar(outbus,sig)
		});
		
		SynthDef.writeOnce(\hdtdebugmix,{arg outbus, inbus;
		var sig,in, left, right;
			
			in= In.ar(inbus,2);
			Out.ar(outbus,in) //don't want to hear it for now
		});
		
		
		
		SynthDef.writeOnce(\hdtonset,{arg outbus=0, inbus, threshold, trigID;  
		var in, detect;
		
		in= In.ar(inbus,1);
		
		detect=OnsetDetection.ar(in,threshold, trigID);
		
		//PrintVal.kr(detect,200,50);
		
		Out.kr(outbus,A2K.kr(detect));
		
		});


		SynthDef.writeOnce(\hdtenergy,{arg outbus, inbus, rmsbus;	
		var in;
		
		in= Mix(In.ar(inbus,2));
		
		Out.kr(outbus,Amplitude.kr(in)); //could replace with a better loudness tracker but hey...  
		
		Out.kr(rmsbus,A2K.kr(RunningSum.rms(in,40))); 
		
		});

		
		SynthDef.writeOnce(\hdtmainmix,{arg outbus, inbus;	
		var in;
		
		in= In.ar(inbus,2);
		
		ReplaceOut.ar(outbus,Limiter.ar(in,0.99,0.01)); 
		
		});
		
		
		SynthDef.writeOnce(\hdtdiskin,{ arg outbus=0,bufnum;
			Out.ar(outbus,
				DiskIn.ar( 1, bufnum )
			)
		});
		
	
		SynthDef.writeOnce(\hdtimpulse,{ arg outbus,freq;
			Out.kr(outbus,
				Impulse.kr(freq) 
			)
		});
	
	
		//thisProcess.interpreter.executeFile("/Volumes/data/sc3code/composition/concertfeb21/hdtsynthdefs1.rtf");
		
		});
		
	
	}

}